; Script generated with the Venis Install Wizard

; Define your application name
!define APPNAME "LLRNet Client"
!define APPNAMEANDVERSION "LLRNet Client 3.5-Stable"

; Main Install settings
Name "${APPNAMEANDVERSION}"
InstallDir "$PROGRAMFILES\LLRNet Client"
InstallDirRegKey HKLM "Software\${APPNAME}" ""
OutFile "LLRNet Installer.exe"

; Modern interface settings
!include "MUI.nsh"
  !include "StrReplace.nsh"
  !include "ReplaceInFile.nsh"
  !include "servicelib.nsh"
  !include "LogicLib.nsh"


!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN "$INSTDIR\llrnet.exe"
!define MUI_CUSTOMFUNCTION_GUIINIT .onInit


!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_LICENSE "LICENSE.txt"
!insertmacro MUI_PAGE_DIRECTORY
Page custom UsernamePage
Page custom IconPage
Page custom ServicePage

!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Set languages (first is default language)
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_RESERVEFILE_LANGDLL

 ReserveFile "client_install.ini"
 ReserveFile "show_icon.ini"
 ReserveFile "install_service.ini"
 !insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
  
Function .onInit
!insertmacro MUI_INSTALLOPTIONS_EXTRACT "client_install.ini"
!insertmacro MUI_INSTALLOPTIONS_EXTRACT "show_icon.ini"
!insertmacro MUI_INSTALLOPTIONS_EXTRACT "install_service.ini"
FunctionEnd

LangString Client_TITLE ${LANG_ENGLISH} "Enter your Username."
LangString Client_SUBTITLE ${LANG_ENGLISH} " "
LangString Icon_TITLE ${LANG_ENGLISH} "Show / Hide Tray Icon"
LangString Icon_SUBTITLE ${LANG_ENGLISH} " "
LangString Service_TITLE ${LANG_ENGLISH} "Install NT Service"
LangString Service_SUBTITLE ${LANG_ENGLISH} " "

Function UsernamePage

   !insertmacro MUI_HEADER_TEXT "$(Client_TITLE)" "$(Client_SUBTITLE)"

   # Display the page.
   !insertmacro MUI_INSTALLOPTIONS_DISPLAY "client_install.ini"

   # Get the user entered values.

FunctionEnd

Function IconPage

   !insertmacro MUI_HEADER_TEXT "$(Icon_TITLE)" "$(Icon_SUBTITLE)"

   # Display the page.
   !insertmacro MUI_INSTALLOPTIONS_DISPLAY "show_icon.ini"

   # Get the user entered values.

FunctionEnd

Function ServicePage

   !insertmacro MUI_HEADER_TEXT "$(Service_TITLE)" "$(Service_SUBTITLE)"

   # Display the page.
   !insertmacro MUI_INSTALLOPTIONS_DISPLAY "install_service.ini"

   # Get the user entered values.

FunctionEnd

Function AdvReplaceInFile
Exch $0 ;file to replace in
Exch
Exch $1 ;number to replace after
Exch
Exch 2
Exch $2 ;replace and onwards
Exch 2
Exch 3
Exch $3 ;replace with
Exch 3
Exch 4
Exch $4 ;to replace
Exch 4
Push $5 ;minus count
Push $6 ;universal
Push $7 ;end string
Push $8 ;left string
Push $9 ;right string
Push $R0 ;file1
Push $R1 ;file2
Push $R2 ;read
Push $R3 ;universal
Push $R4 ;count (onwards)
Push $R5 ;count (after)
Push $R6 ;temp file name
;-------------------------------
GetTempFileName $R6
FileOpen $R1 $0 r ;file to search in
FileOpen $R0 $R6 w ;temp file
StrLen $R3 $4
StrCpy $R4 -1
StrCpy $R5 -1
loop_read:
ClearErrors
FileRead $R1 $R2 ;read line
IfErrors exit
StrCpy $5 0
StrCpy $7 $R2
loop_filter:
IntOp $5 $5 - 1
StrCpy $6 $7 $R3 $5 ;search
StrCmp $6 "" file_write2
StrCmp $6 $4 0 loop_filter
StrCpy $8 $7 $5 ;left part
IntOp $6 $5 + $R3
StrCpy $9 $7 "" $6 ;right part
StrLen $6 $7
StrCpy $7 $8$3$9 ;re-join
StrCmp -$6 $5 0 loop_filter
IntOp $R4 $R4 + 1
StrCmp $2 all file_write1
StrCmp $R4 $2 0 file_write2
IntOp $R4 $R4 - 1
IntOp $R5 $R5 + 1
StrCmp $1 all file_write1
StrCmp $R5 $1 0 file_write1
IntOp $R5 $R5 - 1
Goto file_write2
file_write1:
FileWrite $R0 $7 ;write modified line
Goto loop_read
file_write2:
FileWrite $R0 $7 ;write modified line
Goto loop_read
exit:
FileClose $R0
FileClose $R1
SetDetailsPrint none
Delete $0
Rename $R6 $0
Delete $R6
SetDetailsPrint both
;-------------------------------
Pop $R6
Pop $R5
Pop $R4
Pop $R3
Pop $R2
Pop $R1
Pop $R0
Pop $9
Pop $8
Pop $7
Pop $6
Pop $5
Pop $4
Pop $3
Pop $2
Pop $1
Pop $0
FunctionEnd

Section "LLRNet Client" Section1

	; Set Section properties
	SetOverwrite on

	; Set Section Files and Shortcuts
	SetOutPath "$INSTDIR\"
	File "CHANGELOG.txt"
	File "LICENSE.txt"
	File "LLRnet-gui.exe"
	File "README.txt"
	File "basic.lua"
	File "client.lua"
	File "client_server.lua"
	File "fox.lua"
	File "gui.lua"
	File "init.lua"
	File "llr-clientconfig.txt"
	File "llr-guiconfig.txt"
	File "llr.exe"
	File "llr.ini"
	File "llrnet.bat"
	File "llrnet.exe"
	File "llrnet.lua"
	File "remote-gui.bat"
	File "tosend.txt"
	File "win32.lua"
	File "workfile.txt"
	CreateShortCut "$DESKTOP\LLRNet Client.lnk" "$INSTDIR\llrnet.exe"
	CreateDirectory "$SMPROGRAMS\LLRNet Client"
	CreateShortCut "$SMPROGRAMS\LLRNet Client\LLRNet Client.lnk" "$INSTDIR\llrnet.exe"
	CreateShortCut "$SMPROGRAMS\LLRNet Client\Uninstall.lnk" "$INSTDIR\uninstall.exe"
SectionEnd



Section -FinishSection
        !insertmacro MUI_INSTALLOPTIONS_READ $R7 "show_icon.ini" "Field 3" "State"
        Push "hideTrayIcon = 0"             #-- text to be replaced  within the " "
        Push "hideTrayIcon = $R7"             #-- replace with anything within the " "
        Push all                      #-- replace all occurrences
        Push all                      #-- replace all occurrences
        Push $INSTDIR\llr-clientconfig.txt      #-- file to replace in
        Call AdvReplaceInFile
       	!insertmacro MUI_INSTALLOPTIONS_READ $R0 "client_install.ini" "Field 1" "State"
        Push "nobody"             #-- text to be replaced  within the " "
        Push "$R0"             #-- replace with anything within the " "
        Push all                      #-- replace all occurrences
        Push all                      #-- replace all occurrences
        Push $INSTDIR\llr-clientconfig.txt      #-- file to replace in
        Call AdvReplaceInFile
        !insertmacro MUI_INSTALLOPTIONS_READ $R8 "install_service.ini" "Field 3" "State"
        ${IF} $R8 = 1
              !insertmacro SERVICE "create" "LLRNet Client" "path=$INSTDIR\llrnet.exe;autostart=1;interact=1;"
        ${ENDIF}
        Delete "llr-clientconfig.txt.old"
	WriteRegStr HKLM "Software\${APPNAME}" "" "$INSTDIR"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "DisplayName" "${APPNAME}"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "UninstallString" "$INSTDIR\uninstall.exe"
	WriteUninstaller "$INSTDIR\uninstall.exe"

SectionEnd

; Modern install component descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
	!insertmacro MUI_DESCRIPTION_TEXT ${Section1} ""
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;Uninstall section
Section Uninstall
        KillProcDLL::KillProc "llrnet.exe"
        Sleep 10000
        Push "installed"
        Push "LLRNet Client"
        Push "action=stop;"
        Call un.Service
        Pop $0
        Sleep 5000
        
        Push "installed"
        Push "LLRNet Client"
        Push "action=delete;"
        Call un.Service
        Pop $0
	;Remove from registry...
	DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}"
	DeleteRegKey HKLM "SOFTWARE\${APPNAME}"

	; Delete self
	Delete "$INSTDIR\uninstall.exe"

	; Delete Shortcuts
	Delete "$DESKTOP\LLRNet Client.lnk"
	Delete "$SMPROGRAMS\LLRNet Client\LLRNet Client.lnk"
	Delete "$SMPROGRAMS\LLRNet Client\Uninstall.lnk"

	; Clean up LLRNet Client
	Delete "$INSTDIR\CHANGELOG.txt"
	Delete "$INSTDIR\LICENSE.txt"
	Delete "$INSTDIR\LLRnet-gui.exe"
	Delete "$INSTDIR\README.txt"
	Delete "$INSTDIR\basic.lua"
	Delete "$INSTDIR\client.lua"
	Delete "$INSTDIR\client_server.lua"
	Delete "$INSTDIR\fox.lua"
	Delete "$INSTDIR\gui.lua"
	Delete "$INSTDIR\init.lua"
	Delete "$INSTDIR\llr-clientconfig.txt"
	Delete "$INSTDIR\llr-guiconfig.txt"
	Delete "$INSTDIR\llr.exe"
	Delete "$INSTDIR\llr.ini"
	Delete "$INSTDIR\llrnet.bat"
	Delete "$INSTDIR\llrnet.exe"
	Delete "$INSTDIR\llrnet.lua"
	Delete "$INSTDIR\remote-gui.bat"
	Delete "$INSTDIR\tosend.txt"
	Delete "$INSTDIR\win32.lua"
	Delete "$INSTDIR\workfile.txt"
	Delete "$INSTDIR\*.*"

	; Remove remaining directories
	RMDir "$SMPROGRAMS\LLRNet Client"
	RMDir "$INSTDIR\"

SectionEnd

; eof